import request from 'request';
import requestPromise from 'request-promise';
import logger from '../../User/resources/Log/logger.log.js';

function Instagram(instagram) {
  this.instagram = instagram;
  this.profile_add_redirect_url = instagram.redirect_url;
}
/**
 * TODO  Fetch Instagram user details
 * Function to Fetch Instagram user details
 * @param  {number} network -network id
 * @param  {number} team_id -Team id of user
 * @param  {string} code - code generated by the network
 * @param  {string} redirectUrl - redirectUrl
 * @return {object} Returns object contains user instagram  details
 */
Instagram.prototype.addInstagramProfile = function addInstagram(
  network,
  teamId,
  code,
  redirectUrl
) {
  return new Promise((resolve, reject) => {
    if (!code) {
      reject("Can't get code from instagram!");
    } else {
      return this.getInstagramAccessToken(code,redirectUrl)
        .then(({user_id: uid, acc_token: token}) =>
          this.getInstagramProfileInformation(uid, token)
        )
        .then(userDetails => {
          userDetails.TeamId = teamId;
          userDetails.Network = network;
          resolve(userDetails);
        })
        .catch(error => {
          reject(error);
        });
    }
  });
};

/**
 * TODO  Fetch Instagram user  Long Lived AccessToken
 * Function to Fetch Instagram user long lived AccessToken
 * @param  {string} code - code generated by the network
 * @return {object} Returns object contains user Long lived Access Token with User unique Id
 */
Instagram.prototype.getInstagramAccessToken = function (code,redirectUrl) {
  return new Promise((resolve, reject) => {
    if (!code) {
      reject("Can't get code from instagram!");
    } else {
      return this.getShortLivedAccessToken(code,redirectUrl).then(
        ({user_id: uid, access_token: token}) => {
          request.get(
            {
              headers: {'content-type': 'application/x-www-form-urlencoded'},
              url: `https://graph.instagram.com/access_token?client_secret=${this.instagram.client_secret}&access_token=${token}&grant_type=ig_exchange_token`,
            },
            (error, response, body) => {
              if (error) {
                reject(error);
              } else {
                const parsedResponse = JSON.parse(body);
                const userDetails = {
                  user_id: uid,
                  acc_token: parsedResponse.access_token,
                };
                resolve(userDetails);
              }
            }
          );
        }
      );
    }
  });
};

/**
 * TODO  Fetch Instagram user Short Lived AccessToken
 * Function to Fetch Instagram user Short lived AccessToken
 * @param  {string} code - code generated by the network
 * @return {object} Returns object contains user Short  lived Access Token with User unique Id
 */
Instagram.prototype.getShortLivedAccessToken = function (code,redirectUrl) {
  return new Promise((resolve, reject) => {
    const requestBody = `code=${code}&redirect_uri=${redirectUrl}&client_id=${this.instagram.client_id}&client_secret=${this.instagram.client_secret}&grant_type=authorization_code`;

    request.post(
      {
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        url: 'https://api.instagram.com/oauth/access_token',
        body: requestBody,
      },
      (error, response, body) => {
        if (error) {
          reject(error);
        } else {
          const parsedResponse = JSON.parse(body);

          resolve(parsedResponse);
        }
      }
    );
  });
};

/**
 * TODO  Fetch Instagram user Profile Information
 * Function to Fetch Instagram Profile details
 * @param  {number} userId - Instagram unique user id
 * @param  {string} accToken - Instagram Long Lived AccessToken
 * @return {object} Returns object contains user instagram  details
 */
Instagram.prototype.getInstagramProfileInformation = function (
  userId,
  accToken
) {
  return new Promise((resolve, reject) => {
    request.get(
      {
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        url: `https://graph.instagram.com/me?fields=id,account_type,username,media_count&access_token=${accToken}`,
      },
      (error, response, body) => {
        if (error) {
          reject(error);
        } else {
          logger.info(`Instagram response ${JSON.stringify(body)}`);
          const parsedData = JSON.parse(body);
          if(parsedData.account_type == "PERSONAL"){
          const userDetails = {
            UserName: parsedData.username,
            FirstName: parsedData.username,
            LastName: '',
            Email: '',
            SocialId: parsedData.id,
            ProfilePicture: 'https://i.imgur.com/TMVAonx.png', // Currently basic gives only 4 options
            ProfileUrl: `https://www.instagram.com/${parsedData.username}`,
            AccessToken: accToken,
            RefreshToken: accToken,
            FriendCount: parsedData?.media_count ?? 0,
            Info: '',
          };
           resolve(userDetails);
          }
          else{
            reject(new Error('Please add only personal account, If you want to add business please choose another option.'));
          }
        }
      }
    );
  });
};

/**
 * TODO  Fetch Instagram Feeds from specified User
 * Function to Fetch Instagram Feeds from specified User
 * @param  {string} accToken - Instagram Long Lived AccessToken
 * @param  {number} socialId - Instagram unique user id
 * @return {object} Returns object contains user instagram  details
 */
Instagram.prototype.getInstagramFeeds = function (accessToken, socialId) {
  return new Promise((resolve, reject) => {
    if (!accessToken) {
      reject(new Error('Invalid accesstoken!'));
    } else {
      let postDetails = [];
      const url = `https://graph.instagram.com/${socialId}/media?access_token=${accessToken}&fields=media_type,media_url,caption,timestamp`;

      return requestPromise
        .get(url)
        .then(async body => {
          const parsedBody = JSON.parse(body);
          const promises = parsedBody.data.map(async post => {
            const mediaUrl = await this.getmediaUrl(
              post.id,
              post.media_type,
              post.media_url,
              accessToken
            );
            const data = {
              postId: post.id,
              socialId,
              userName: post.username,
              publishedDate: post.timestamp,
              captionId: '',
              captionText: post.caption ?? '',
              isUserLiked: false,
              likeCount: '',
              commentCount: '',
              type: post.media_type,
              link: '',
              locationName: '',
              locationId: '',
              mediaUrl,
            };

            return data;
          });

          postDetails = await Promise.all(promises);
        })
        .then(() => {
          resolve(postDetails);
        })
        .catch(error => {
          reject(error);
        });
    }
  });
};
/**
 * TODO  Fetch Instagram single and multiple media Url from specified User
 * Function to Fetch Instagram single and multiple media Url from specified User
 * @param  {number} feedId - Instagram Feed id
 * @param  {string} type - Instagram media type for the Feed
 * @param  {string} mUrl - Instagram single media Url
 * @param  {string} accToken - Instagram Long Lived AccessToken
 * @return {object} Returns object contains single and multiple media Url from specified Feed
 */
Instagram.prototype.getmediaUrl = async function (
  feedId,
  type,
  mUrl,
  accessToken
) {
  return new Promise((resolve, reject) => {
    const mediaUrl = [];

    if (type == 'CAROUSEL_ALBUM') {
      const url = `https://graph.instagram.com/${feedId}/children?fields=media_type,media_url&access_token=${accessToken}`;

      return requestPromise
        .get(url)
        .then(body => {
          const parsedBody = JSON.parse(body);

          parsedBody.data.map(post => {
            mediaUrl.push({
              media_type: post.media_type,
              media_url: post.media_url,
            });
          });
          resolve(mediaUrl);
        })
        .catch(error => {
          reject(error);
        });
    }
    mediaUrl.push({
      media_type: type,
      media_url: mUrl,
    });
    resolve(mediaUrl);
  });
};
export default Instagram;
